<?php

defined('_JEXEC') or die;

use Joomla\Registry\Registry;

$theme = JHtml::_('theme');

// Load jQuery
JHtml::_('jquery.framework');

// Register helpers
JHtml::register('attrs', [$theme['view'], 'attrs']);
JHtml::register('render', [$theme['view'], 'render']);
JHtml::register('section', [$theme['view'], 'section']);
JHtml::register('builder', [$theme['builder'], 'render']);

// Add article loader
$theme['view']->addLoader(function ($name, $parameters, $next) {

    $defaults = array_fill_keys(['title', 'author', 'content', 'hits', 'created', 'modified', 'published', 'category', 'image', 'tags', 'icons', 'readmore', 'pagination', 'link', 'permalink', 'event'], null);

    // Vars
    extract(array_replace($defaults, $parameters), EXTR_SKIP);

    // Params
    if (!isset($params)) {
        $params = $article->params;
    } elseif (is_array($params)) {
        $params = new Registry($params);
    }

    // Link
    if (!isset($link)) {
        $link = ContentHelperRoute::getArticleRoute($article->slug, $article->catid, $article->language);
    }

    // Permalink
    if (!isset($permalink)) {
        $permalink = JRoute::_($link, true, -1);
    }

    if ($params->get('access-view') === false) {
        $menu = JFactory::getApplication()->getMenu()->getActive();
        $link = new JUri(JRoute::_("index.php?option=com_users&view=login&Itemid={$menu->id}", false));
        $link->setVar('return', base64_encode(JRoute::_($link, false)));
    }

    // Title
    if ($params->get('show_title')) {

        $title = $article->title;

        if ($params->get('link_titles')) {
            $title = JHtml::_('link', $link, $title, ['class' => 'uk-link-reset']);
        }
    }

    // Author
    if ($params->get('show_author')) {

        $author = $article->created_by_alias ?: $article->author;

        if ($params->get('link_author') && $article->contact_link) {
            $author = JHtml::_('link', $article->contact_link, $author);
        }
    }

    if (!empty($article->created_by_alias)) {
        $article->author = $article->created_by_alias;
    }

    // Hits
    if ($params->get('show_hits')) {
        $hits = $article->hits;
    }

    // Create date
    if ($params->get('show_create_date')) {
        $created = JHtml::_('date', $article->created, JText::_('DATE_FORMAT_LC3'));
        $created = "<time datetime=\"" . JHtml::_('date', $article->created, 'c') . "\">{$created}</time>";
    }

    // Modify date
    if ($params->get('show_modify_date')) {
        $modified = JHtml::_('date', $article->modified, JText::_('DATE_FORMAT_LC3'));
        $modified = "<time datetime=\"" . JHtml::_('date', $article->modified, 'c') . "\">{$modified}</time>";
    }

    // Publish date
    if ($params->get('show_publish_date')) {
        $published = JHtml::_('date', $article->publish_up, JText::_('DATE_FORMAT_LC3'));
        $published = "<time datetime=\"" . JHtml::_('date', $article->publish_up, 'c') . "\">{$published}</time>";
    }

    // Category
    if ($params->get('show_category')) {

        $category = $article->category_title;

        if ($params->get('link_category') && $article->catslug) {
           $category = JHtml::_('link', JRoute::_(ContentHelperRoute::getCategoryRoute($article->catslug)), $category);
        }
    }

    // Image
    if (is_string($image)) {

        $images = new Registry($article->images);
        $imageType = $image;

        if ($images->get("image_{$imageType}")) {

            $image = new stdClass();
            $image->link = $params->get('link_titles') ? $link : null;
            $image->align = $images->get("float_{$imageType}") ?: $params->get("float_{$imageType}");
            $image->caption = $images->get("image_{$imageType}_caption");
            $image->attrs = [
                'src' => $images->get("image_{$imageType}"),
                'alt' => $images->get("image_{$imageType}_alt"),
                'title' => $images->get("image_{$imageType}_caption"),
            ];

        } else {

            $image = null;
        }
    }

    // Tags
    if ($params->get('show_tags', 1) && !empty($article->tags->itemTags)) {
        $tags = JLayoutHelper::render('joomla.content.tags', $article->tags->itemTags);
    }

    // Icons
    if (!isset($icons)) {
        $icons['print'] = $params->get('show_print_icon') ? JHtml::_('icon.print_popup', $article, $params) : '';
        $icons['email'] = $params->get('show_email_icon') ? JHtml::_('icon.email', $article, $params) : '';
        $icons['edit']  = $params->get('access-edit') ? JHtml::_('icon.edit', $article, $params) : '';
    }

    $icons = array_filter($icons);

    // Readmore
    if ($params->get('show_readmore') && !empty($article->readmore)) {

        $readmore = new stdClass();
        $readmore->link = $link;

        if ($params->get('access-view')) {

            $attribs = new Registry($article->attribs);

            if (!$readmore->text = $attribs->get('alternative_readmore')) {
                $readmore->text = JText::_($params->get('show_readmore_title') ? 'COM_CONTENT_READ_MORE' : 'COM_CONTENT_READ_MORE_TITLE');
            }

        } else {

            $readmore->text = JText::_('COM_CONTENT_REGISTER_TO_READ_MORE');
        }

        if ($params->get('show_readmore_title')) {
            $readmore->text .= JHtml::_('string.truncate', $article->title, $params->get('readmore_limit'));
        }
    }

    // Pagination
    if (isset($article->pagination)) {
        $pagination = new stdClass();
        $pagination->prev = $article->prev;
        $pagination->next = $article->next;
    }

    // Event
    if (isset($article->event)) {

        $event = $article->event;

        if ($params->get('show_intro')) {
            $event->afterDisplayTitle = '';
        }
    }

    return $next($name, array_diff_key(get_defined_vars(), array_flip(['next', 'name', 'parameters', 'defaults'])));

}, 'article*');
