<?php

defined('_JEXEC') or die;

JHtml::addIncludePath(JPATH_COMPONENT . '/helpers');
JHtml::_('behavior.caption');

$app = JFactory::getApplication();
$app->input->set('layout', 'blog');

// Parameter shortcuts
$params  = $this->params;
$lead    = $this->lead_items ?: [];
$columns = $params->get('num_columns');
$intro   = @array_chunk($this->intro_items, $columns) ?: [];

// Article template
$article = JHtml::_('render', 'article:blog', function ($item) {
    return [
        'article' => $item,
        'content' => $item->introtext,
        'image' => 'intro',
    ];
});

?>

<?php if ($params->get('show_page_heading')
        || $params->get('page_subheading')
        || $params->get('show_category_title', 1)
        || ($params->def('show_description_image', 1) && $this->category->getParams()->get('image'))
        || ($params->get('show_description', 1) && $this->category->description)
        || ($this->params->get('show_cat_tags', 1) && !empty($this->category->tags->itemTags))
    ) : ?>

<div class="uk-panel">

    <?php if ($params->get('show_page_heading')) : ?>
    <h1><?= $this->escape($params->get('page_heading')) ?></h1>
    <?php endif ?>

    <?php if ($params->get('page_subheading')) : ?>
    <h2><?= $this->escape($params->get('page_subheading')) ?></h2>
    <?php endif ?>

    <?php if ($params->get('show_category_title')) : ?>
    <h3><?= $this->category->title ?></h3>
    <?php endif ?>

    <?php if ($params->get('show_description_image') && $this->category->getParams()->get('image')) : ?>
    <img src="<?= $this->category->getParams()->get('image') ?>" alt="<?php echo htmlspecialchars($this->category->getParams()->get('image_alt')); ?>">
    <?php endif ?>

    <?php if ($params->get('show_description') && $this->category->description) : ?>
    <div class="uk-margin"><?= JHtml::_('content.prepare', $this->category->description, '', 'com_content.category') ?></div>
    <?php endif ?>

    <?php if ($params->get('show_cat_tags') && !empty($this->category->tags->itemTags)) : ?>
        <?= JLayoutHelper::render('joomla.content.tags', $this->category->tags->itemTags) ?>
    <?php endif ?>

</div>
<?php endif ?>

<?php if (empty($this->lead_items) && empty($this->intro_items) && empty($this->link_items)) : ?>
    <?php if ($params->get('show_no_articles', 1)) : ?>
    <p><?= JText::_('COM_CONTENT_NO_ARTICLES') ?></p>
    <?php endif ?>
<?php endif ?>

<?php foreach ($lead as $item) : ?>
<?= $article($item) ?>
<?php endforeach ?>

<?php foreach ($intro as $row) : ?>
<div class="uk-child-width-1-<?= $columns ?>@m" uk-grid>
    <?php foreach ($row as $item) : ?>
    <div><?= $article($item) ?></div>
    <?php endforeach ?>
</div>
<?php endforeach ?>

<?php if (!empty($this->link_items)) : ?>
<div class="uk-margin-large">
    <div class="uk-width-xxlarge uk-margin-auto uk-text-center">
        <h3><?= JText::_('COM_CONTENT_MORE_ARTICLES') ?></h3>
        <ul class="uk-list">
            <?php foreach ($this->link_items as $item) : ?>
            <li><a href="<?= JRoute::_(ContentHelperRoute::getArticleRoute($item->slug, $item->catid)) ?>"><?= $item->title ?></a></li>
            <?php endforeach ?>
        </ul>
    </div>
</div>
<?php endif ?>

<?php if (($params->def('show_pagination', 1) == 1  || ($params->get('show_pagination') == 2)) && ($this->pagination->get('pages.total') > 1)) : ?>
<?= $this->pagination->getPagesLinks() ?>
<?php endif ?>
