<?php

use YOOtheme\Http\Exception;

$config = [

    'name' => 'yootheme/joomla-theme',

    'main' => 'YOOtheme\\Theme\\Joomla',

    'routes' => function ($route) {

        $user = JFactory::getUser();
        $config = JFactory::getConfig();
        $document = JFactory::getDocument();

        $route->get('/customizer', function ($return = false, $response) use ($config, $document) {

            $this['events']->trigger('theme.admin', [$this['theme']]);
            $this['@customizer']->addData('return', $return ?: $this['url']->to('administrator/index.php'));
            $this['@customizer']->addData('config', $this['theme']['@config']);

            JHtml::_('behavior.keepalive');
            JHtml::_('bootstrap.tooltip');

            $document->setTitle("Website Builder - {$config->get('sitename')}");
            $document->addFavicon(JUri::root(true).'/administrator/templates/isis/favicon.ico');

            return $document->render(false, [
                'file' => 'component.php',
                'template' => $this['theme']->template,
            ]);
        });

        $route->post('/customizer', function ($config, $response) use ($user) {

            if (!$user->authorise('core.edit', 'com_templates')) {
                throw new Exception(403, 'Insufficient User Rights.');
            }

            // alter custom_data type to MEDIUMTEXT
            $query = "SHOW FIELDS FROM @extensions WHERE Field = 'custom_data'";
            $alter = "ALTER TABLE @extensions CHANGE `custom_data` `custom_data` MEDIUMTEXT NOT NULL";

            if ($this['db']->fetchObject($query)->Type == 'text') {
                $this['db']->executeQuery($alter);
            }

            // update template style params
            $params = array_replace($this['theme']->params->toArray(), ['config' => json_encode($config)]);
            $this['db']->update('@template_styles', ['params' => json_encode($params)], ['id' => $this['theme']->id]);

            return 'success';
        });

    },

    'events' => [

        'init' => function () {
            $this['kernel']->addMiddleware(function ($request, $response, $next) {

                $user = JFactory::getUser();
                $allowed = in_array($request->getParam('p'), ['theme/image'], true);

                // check user permissions
                if (!$allowed && !$user->authorise('core.edit', 'com_templates') && !$user->authorise('core.edit', 'com_content')) {
                    throw new Exception(403, 'Insufficient User Rights.');
                }

                return $next($request, $response);
            });
        },

        'theme.init' => function ($theme) {
            $theme['@config']->merge($this['@config']->get('defaults'), true);
        },

    ],

    'config' => [

        'panels' => [

            'system' => [
                'title' => 'System',
                'width' => 400,
                'fields' => [
                ]

            ],

            'system-post' => [
                'title' => 'Post',
                'width' => 400,
                'fields' => [

                    'post.meta_style' => [
                        'label' => 'Meta Style',
                        'description' => 'Display the meta text in a sentence or a horizontal list.',
                        'type' => 'select',
                        'options' => [
                            'List' => 'list',
                            'Sentence' => 'sentence',
                        ],
                    ],

                    'post.header_align' => [
                        'label' => 'Alignment',
                        'description' => 'The alignment option applies to both, the blog and single posts.',
                        'type' => 'checkbox',
                        'text' => 'Center the header and footer',
                    ],

                    'post.content_width' => [
                        'label' => 'Max Width',
                        'description' => 'Set a smaller width than the image\'s for the content.',
                        'type' => 'checkbox',
                        'text' => 'Small',
                    ],

                    'post.content_dropcap' => [
                        'label' => 'Drop Cap',
                        'description' => 'Set a large initial letter that drops below the first line of the first paragraph.',
                        'type' => 'checkbox',
                        'text' => 'Show drop cap',
                    ],

               ],
            ],

            'system-blog' => [
                'title' => 'Blog',
                'width' => 400,
                'fields' => [

                    'blog.column_gutter' => [
                        'type' => 'checkbox',
                        'text' => 'Large gutter',
                        'show' => 'blog.column != "1"',
                    ],

                    'blog.column_divider' => [
                        'description' => 'Set a larger gutter and display dividers between columns.',
                        'type' => 'checkbox',
                        'text' => 'Display dividers between columns',
                        'show' => 'blog.column != "1"',
                    ],

                    'blog.content_align' => [
                        'label' => 'Alignment',
                        'description' => 'This option applies to the blog overview and not to single posts. To center the post\'s header and footer, go to the post settings.',
                        'type' => 'checkbox',
                        'text' => 'Center the content',
                    ],

                    'blog.button_style' => [
                        'label' => 'Button',
                        'description' => 'Select a style for the continue reading button.',
                        'type' => 'select',
                        'options' => [
                            'Default' => 'default',
                            'Primary' => 'primary',
                            'Secondary' => 'secondary',
                            'Danger' => 'danger',
                            'Text' => 'text',
                        ],
                    ],

                    'blog.navigation' => [
                        'label' => 'Navigation',
                        'description' => 'Use a numeric pagination or previous/next links to move between blog pages.',
                        'type' => 'select',
                        'options' => [
                            'Pagination' => 'pagination',
                            'Previous/Next' => 'previous/next',
                        ],
                    ],

                ],
            ]

        ],

        'defaults' => [

            'post' => [

                'meta_style' => 'sentence',
                'header_align' => 0,
                'content_width' => 0,
                'content_dropcap' => 0,
                'navigation' => 1,
            ],

            'blog' => [

                'column_gutter' => 0,
                'column_divider' => 0,
                'content_align' => 0,
                'button_style' => 'default',
                'navigation' => 'pagination',
            ],

        ],

    ],

];

return defined('_JEXEC') ? $config : false;
