<?php

/**
 * @version 3.4.8
 * @package PWebContact
 * @subpackage Mailchimp
 * @copyright © 2016 Perfect Web sp. z o.o., All rights reserved. http://www.perfect-web.co
 * @license GNU General Public License http://www.gnu.org/licenses/gpl-3.0.html
 * @author Andrzej Kawula, Piotr Moćko
 */
// no direct access
defined('_JEXEC') or die('Restricted access');

class modPWebContactMailchimpHelper
{

    public static function getLists($options)
    {
        $response = self::doRequest('GET','lists', $options);

        $lists = array();
        if ($response && isset($response->lists))
        {
            foreach ($response->lists as $list)
            {
                $lists[$list->id] = $list->name;
            }
        }

        return $lists;
    }

    public static function subscribe($id_list, $email, $name = '', $fields = array(), $options = array())
    {
        if (!empty($name)) {
            $fields['FNAME'] = $name;
        }

        $data = array(
            'email_address' => $email,
            'email_type' => 'html',
            'status' => (!empty($options['opt']) ? 'pending' : 'subscribed'),
        );

        $result = self::doRequest('post', 'lists/' . $id_list . '/members', $options, json_encode($data),
            array('Content-Type: multipart/form-data'));

        // change fields
        $_fields = array();
        foreach($fields as $key => $value) {
            $_fields[strtoupper($key)] = $value;
        }
        unset($fields);

        if($result && isset($result->id)) {
            self::doRequest('patch', 'lists/' . $id_list . '/members/' . $result->id, $options, json_encode(array('merge_fields' => $_fields)),
                array('Content-Type: multipart/form-data'));
        }
    }

    protected static function doRequest($method = 'post', $rest_path, $options, $data = array(), $headers = array(), $drivers = array('stream', 'curl'))
    {
        $app = JFactory::getApplication();
        if (!defined('PWEBCONTACT_DEBUG'))
            define('PWEBCONTACT_DEBUG', false);

        $key_parts = explode('-', $options['apikey']);
        if (empty($options['apikey']) || count($key_parts) < 2)
        {
            $msg = 'Mailchimp error: ' . JText::_('MOD_PWEBCONTACT_BAD_API_KEY');
            if (PWEBCONTACT_DEBUG)
                modPwebcontactHelper::setLog($msg);
            if ($app->isAdmin())
                $app->enqueueMessage($msg, 'error');
            return false;
        }

        $url = 'https://' . $key_parts[1] . '.api.mailchimp.com/3.0/';

        $verify_peer = true;
        while (!empty($drivers))
        {
            try
            {
                $driver = $drivers[0];
                $http   = JHttpFactory::getHttp(null, $driver);
                if (empty($http))
                {
                    array_shift($drivers);
                }
                else
                {
                    // basic auth for api v3
                    $http->setOption('userauth', $options['apikey']);
                    $http->setOption('passwordauth', $options['apikey']);

                    $http->setOption('verify_peer', $verify_peer);
                    if ($driver == 'curl')
                    {
                        $http->setOption('transport.curl', array(CURLOPT_SSL_VERIFYPEER => $verify_peer));
                    }

                    switch(strtoupper($method)) {
                        case 'GET':
                            $response = $http->get($url . $rest_path, $data, $headers);
                            break;

                        case 'POST':
                        default:
                            $response = $http->post($url . $rest_path, $data, $headers);
                            break;

                        case 'PUT':
                            $response = $http->put($url . $rest_path, $data, $headers);
                            break;

                        case 'PATCH':
                            $response = $http->patch($url . $rest_path, $data, $headers);
                            break;
                    }

                    $result  = json_decode($response->body);
                    $drivers = null;
                }
            }
            catch (Exception $e)
            {
                if ($verify_peer)
                {
                    $verify_peer = false;
                }
                else
                {
                    $verify_peer = true;
                    array_shift($drivers);
                }

                $msg = 'Mailchimp HTTP request error: ' . $e->getMessage();
                if (PWEBCONTACT_DEBUG)
                    modPwebcontactHelper::setLog($msg);

                if (empty($drivers))
                {
                    if ($app->isAdmin())
                        $app->enqueueMessage($msg, 'error');
                    return false;
                }
            }
        }

        if (isset($result->errors) && isset($result->errors[0]) && isset($result->errors[0]->error))
        {
            $msg = 'Mailchimp REST response: ' . $result->errors[0]->error;
            if (PWEBCONTACT_DEBUG)
                modPwebcontactHelper::setLog($msg);
            if ($app->isAdmin())
                $app->enqueueMessage($msg, 'error');
        }
        elseif (isset($result->status) && $result->status == 'error')
        {
            $msg = 'Mailchimp REST response: ' . $result->error;
            if (PWEBCONTACT_DEBUG)
                modPwebcontactHelper::setLog($msg);
            if ($app->isAdmin())
                $app->enqueueMessage($msg, 'error');
        }
        else
        {
            if (PWEBCONTACT_DEBUG)
                modPwebcontactHelper::setLog('Mailchimp request success');
        }

        return $result;
    }

}
