<?php

namespace YOOtheme\Joomla;

use YOOtheme\Util\Collection;

class Option extends Collection
{
    /**
     * Constructor.
     *
     * @param Database $db
     * @param string   $element
     * @param string   $folder
     */
    public function __construct($db, $element, $folder = '')
    {
        $row = $db->fetchAssoc("SELECT custom_data FROM @extensions WHERE element = :element AND folder = :folder LIMIT 1", compact('element', 'folder'));

        if ($data = json_decode($row['custom_data'], true)) {
            parent::__construct($data);
        }

        \JEventDispatcher::getInstance()->register('onAfterRespond', function () use ($db, $row, $element, $folder) {
            if (($data = (string) $this) != $row['custom_data']) {
                $db->update('@extensions', ['custom_data' => $data], compact('element', 'folder'));
            }
        });
    }
}
