<?php

// Rendered?
if ($theme->get('_header')) {
    return;
} else {
    $theme->set('_header', true);
}

// Options
$layout = $theme->get('header.layout');
$fullwidth = $theme->get('header.fullwidth');
$logo = $theme->get('logo.image') || $theme->get('logo.text');
$class = array_merge(['tm-header', 'uk-visible@' . $theme->get('mobile.breakpoint')], isset($class) ? (array) $class : []);

// Container
$container = ['class' => ['uk-navbar-container']];

// Transparent
$transparent = isset($transparent) ? $transparent : false;
if ($transparent) {
    $class[] = 'tm-header-transparent';
    $container['class'][] = "uk-navbar-transparent uk-{$transparent}";
}

// Navbar
$navbar = $theme->get('navbar', []);
$navbar_attrs = [
    'uk-navbar' => json_encode(array_filter([
        'align' => $navbar['dropdown_align'],
        'click' => $navbar['dropdown_click'],
        'boundary-align' => $navbar['dropdown_boundary'],
        'dropbar' => $navbar['dropbar'] ? true : null,
        'dropbar-anchor' => $navbar['dropbar'] ? '!.uk-container' : null,
        'dropbar-mode' => $navbar['dropbar']
    ]))
];

// Sticky
if ($sticky = $navbar['sticky']) {
    $container['uk-sticky'] = json_encode(array_filter([
        'media' => 768,
        'show-on-up' => $sticky == 2,
        'animation' => $transparent || $sticky == 2 ? 'uk-animation-slide-top' : '',
        'top' => $transparent ? '!.js-sticky' : 1,
        'clsActive' => 'uk-active uk-navbar-sticky',
        'clsInactive' => $transparent ? "uk-navbar-transparent uk-{$transparent}" : false,
    ]));
}

?>

<div<?= $this->attrs(['class' => $class]) ?>>

<?php

/*
 * Horizontal layouts
 */

if (in_array($layout, ['horizontal-left', 'horizontal-center', 'horizontal-right'])) : ?>
    <div<?= $this->attrs($container) ?>>

        <div class="uk-container <?= $fullwidth ? 'uk-container-expand' : '' ?>">
            <nav<?= $this->attrs($navbar_attrs) ?>>

                <?php if ($logo || $layout == 'horizontal-left' && $this->countModules('navbar')) : ?>
                <div class="uk-navbar-left">

                    <?= $logo ? $this->render('header-logo', ['class' => 'uk-navbar-item', 'img' => 'uk-responsive-height']) : '' ?>

                    <?php if ($layout == 'horizontal-left') : ?>
                        <jdoc:include type="modules" name="navbar" />
                    <?php endif ?>

                </div>
                <?php endif ?>

                <?php if ($layout == 'horizontal-center' && $this->countModules('navbar')) : ?>
                <div class="uk-navbar-center">
                    <jdoc:include type="modules" name="navbar" />
                </div>
                <?php endif ?>

                <?php if ($this->countModules('header') || $layout == 'horizontal-right' && $this->countModules('navbar')) : ?>
                <div class="uk-navbar-right">

                    <?php if ($layout == 'horizontal-right' && $this->countModules('navbar')) : ?>
                        <jdoc:include type="modules" name="navbar" />
                    <?php endif ?>

                    <jdoc:include type="modules" name="header" />

                </div>
                <?php endif ?>

            </nav>
        </div>

    </div>
<?php endif ?>

<?php

/*
 * Stacked Center layouts
 */

if (in_array($layout, ['stacked-center-a', 'stacked-center-b', 'stacked-center-split'])) : ?>

    <?php if ($logo && $layout != 'stacked-center-split' || $layout == 'stacked-center-a' && $this->countModules('header')) : ?>
    <div class="tm-headerbar-top<?= $transparent ? ' uk-'.$transparent : '' ?>">
        <div class="uk-container<?= $fullwidth ? ' uk-container-expand' : '' ?>">

            <?php if ($logo) : ?>
            <div class="uk-text-center">
                <?= $this->render('header-logo') ?>
            </div>
            <?php endif ?>

            <?php if ($layout == 'stacked-center-a' && $this->countModules('header')) : ?>
            <div class="tm-headerbar-stacked uk-grid-medium uk-child-width-auto uk-flex-center uk-flex-middle" uk-grid>
                <jdoc:include type="modules" name="header" style="cell" />
            </div>
            <?php endif ?>

        </div>
    </div>
    <?php endif ?>

    <?php if ($this->countModules('navbar')) : ?>
    <div<?= $this->attrs($container) ?>>

        <div class="uk-container <?= $fullwidth ? 'uk-container-expand' : '' ?>">
            <nav<?= $this->attrs($navbar_attrs) ?>>

                <div class="uk-navbar-center">
                    <jdoc:include type="modules" name="navbar" />
                </div>

            </nav>
        </div>

    </div>
    <?php endif ?>

    <?php if (in_array($layout, ['stacked-center-b', 'stacked-center-split']) && $this->countModules('header')) : ?>
    <div class="tm-headerbar-bottom<?= $transparent ? ' uk-'.$transparent : '' ?>">
        <div class="uk-container <?= $fullwidth ? 'uk-container-expand' : '' ?>">
            <div class="uk-grid-medium uk-child-width-auto uk-flex-center uk-flex-middle" uk-grid>
                <jdoc:include type="modules" name="header" style="cell" />
            </div>
        </div>
    </div>
    <?php endif ?>

<?php endif ?>

<?php

/*
 * Stacked Left layouts
 */

if ($layout == 'stacked-left-a' || $layout == 'stacked-left-b') : ?>

    <?php if ($logo || $this->countModules('header')) : ?>
    <div class="tm-headerbar-top<?= $transparent ? ' uk-'.$transparent : '' ?>">
        <div class="uk-container <?= $fullwidth ? 'uk-container-expand' : '' ?> uk-flex uk-flex-middle">

            <?= $logo ? $this->render('header-logo') : '' ?>

            <?php if ($this->countModules('header')) : ?>
            <div class="uk-margin-auto-left">
                <div class="uk-grid-medium uk-child-width-auto uk-flex-middle" uk-grid>
                    <jdoc:include type="modules" name="header" style="cell" />
                </div>
            </div>
            <?php endif ?>

        </div>
    </div>
    <?php endif ?>

    <?php if ($this->countModules('navbar')) : ?>
    <div<?= $this->attrs($container) ?>>

        <div class="uk-container <?= $fullwidth ? 'uk-container-expand' : '' ?>">
            <nav<?= $this->attrs($navbar_attrs) ?>>

                <?php if ($layout == 'stacked-left-a') : ?>
                <div class="uk-navbar-left">
                    <jdoc:include type="modules" name="navbar" />
                </div>
                <?php endif ?>

                <?php if ($layout == 'stacked-left-b') : ?>
                <div class="uk-navbar-left uk-flex-auto">
                    <jdoc:include type="modules" name="navbar" />
                </div>
                <?php endif ?>

            </nav>
        </div>

    </div>
    <?php endif ?>

<?php endif ?>

<?php

/*
 * Toggle layouts
 */

if ($layout == 'toggle-offcanvas' || $layout == 'toggle-modal') : ?>

    <div<?= $this->attrs($container) ?>>
        <div class="uk-container <?= $fullwidth ? 'uk-container-expand' : '' ?>">
            <nav<?= $this->attrs($navbar_attrs) ?>>

            <?php if ($logo) : ?>
            <div class="uk-navbar-left">
                <?= $this->render('header-logo', ['class' => 'uk-navbar-item', 'img' => 'uk-responsive-height']) ?>
            </div>
            <?php endif ?>

            <?php if ($this->countModules('navbar')) : ?>
            <div class="uk-navbar-right">
                <a class="uk-navbar-toggle" href="#" uk-toggle="target: !.uk-navbar-container + [uk-offcanvas], [uk-modal]">
                    <?php if ($navbar['toggle_text']) : ?>
                    <span class="uk-margin-small-right"><?= JText::_('TPL_YOOTHEME_MENU') ?></span>
                    <?php endif ?>
                    <div uk-navbar-toggle-icon></div>
                </a>
            </div>
            <?php endif ?>

            </nav>
        </div>
    </div>

    <?php if ($layout == 'toggle-offcanvas' && ($this->countModules('navbar') || $this->countModules('header'))) : ?>
    <div uk-offcanvas="flip: true"<?= $this->attrs($navbar['offcanvas'] ?: []) ?>>
        <div class="uk-offcanvas-bar">

            <jdoc:include type="modules" name="navbar" />

            <?php if ($this->countModules('header')) : ?>
            <div class="uk-margin-large-top">
                <jdoc:include type="modules" name="header" style="grid-stack" />
            </div>
            <?php endif ?>

        </div>
    </div>
    <?php endif ?>

    <?php if ($layout == 'toggle-modal' && ($this->countModules('navbar') || $this->countModules('header'))) : ?>
    <div class="uk-modal-full" uk-modal>
        <div class="uk-modal-dialog uk-modal-body">
            <button class="uk-modal-close-full" type="button" uk-close></button>
            <div class="uk-flex uk-flex-center uk-flex-middle uk-text-center" uk-height-viewport>
                <div>

                    <jdoc:include type="modules" name="navbar" />

                    <?php if ($this->countModules('header')) : ?>
                    <div class="uk-margin-large-top">
                        <jdoc:include type="modules" name="header" style="grid-stack" />
                    </div>
                    <?php endif ?>

                </div>
            </div>
        </div>
    </div>
    <?php endif ?>

<?php endif ?>

</div>
