/**
 * @package   	JCE
 * @copyright 	Copyright (c) 2009-2017 Ryan Demmer. All rights reserved.
 * @license   	GNU/GPL 2 or later - http://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * JCE is free software. This version may have been modified pursuant
 * to the GNU General Public License, and as distributed it includes or
 * is derivative of works licensed under the GNU General Public License or
 * other free or open source software licenses.
 */

var tinymce = {
    settings: {
        "language": "en",
        "site_url": ""
    },

    addI18n: function(p, o) {
        return Wf.addI18n(p, o);
    },

    convertURL: function(src) {
        return src;
    },

    windowManager: {
        params: {
            "window": window.parent,
            "callback": function(selected, data) {
                var win = window.parent,
                    s = tinyMCEPopup.editor.settings,
                    value = data[0].url;

                if (win.jQuery) {
                    // Joomla 3.5.x Media Field
                    var wrapper = win.jQuery('#' + s.element).parents('.field-media-wrapper').get(0);

                    if (wrapper) {
                        var inst = win.jQuery(wrapper).data('fieldMedia');

                        if (inst) {
                            return inst.setValue(value);
                        }
                    }

                    win.jQuery('#' + s.element).val(value).change();
                } else {
                    var el;

                    if (s.element) {
                        el = win.document.getElementById(s.element);
                    }

                    if (el) {
                        el.value = value;
                    }
                }
            }
        },

        // Open a modal window . This is only used from inside an existing modal, eg: Help or Image Editor
        open: function(args, params) {
            var $ = jQuery,
                s = tinyMCEPopup.editor.settings;

            args.url += '&' + s.token + '=1';

            if (s.component_id) {
                args.url += '&component_id=' + s.component_id;
            }

            args.url += '&standalone=1';

            var div = $('<div class="uk-inline-help uk-modal" />');

            var html = '<div class="uk-modal-dialog uk-modal-dialog-blank">' +
                '	<button class="uk-modal-close uk-close"></button>' +
                '	<div class="uk-modal-header"><h3><strong>' + (args.title || "") + '</strong></h3></div>' +
                '	<iframe src="' + args.url + '" frameborder="0"></iframe>' +
                '</div>';

            $(div).html(html).find('.uk-close').click(function(e) {
                e.preventDefault();
                $(div).removeClass('uk-open').delay(150).remove();
            });

            $(div).appendTo('body').addClass('uk-open').show();

            // store params
            tinymce.windowManager.params = params;
        },
        // Close a modal window opened using a Joomla Modal method or a JCE Modal.
        close: function() {
            var win = window.parent,
                s = tinyMCEPopup.editor.settings;

            // JCE dialog
            if (typeof win.$jce !== 'undefined') {
                return win.$jce.closeDialog('#' + s.element + '_browser');
            }

            // Joomla 3.5.x Media Field
            if (s.element && typeof win.jQuery.fieldMedia !== 'undefined') {
                var wrapper = win.jQuery('#' + s.element).parents('.field-media-wrapper').get(0);

                var inst = win.jQuery(wrapper).data('fieldMedia');

                if (inst) {
                    return inst.modalClose();
                }
            }

            // jModalClose
            if (typeof win.jModalClose !== 'undefined') {
                return win.jModalClose();
            }

            // try squeezebox
            if (typeof win.SqueezeBox !== 'undefined') {
                return win.SqueezeBox.close();
            }
        }
    },

    getParam: function(n, dv) {
        var s = tinyMCEPopup.editor.settings,
            v = s[n];
        return (typeof v !== "undefined") ? v : dv;
    }
};

var tinyMCE = tinymce;